#!/usr/bin/python3
from insights_protocol import StepBase, ExchangeDataHolder
from embedded_linux import run_with_own_loader, run, unpack_xz, fix_symbolic_links
import os
import sys
import constant


class MyInsightsPythonStep(StepBase):

    # Called for every input
    async def invoke(self, exchange_data_holder: ExchangeDataHolder) -> ExchangeDataHolder:
        print("\nStart processing " + str(exchange_data_holder))

        for document in exchange_data_holder.documents:
            # print directory list of the extracted file system
            print("Extracted file system root: %s\n" % os.listdir(constant.OWN_FILE_SYSTEM_DIR), file=sys.stderr)

            # try to update and install a new module tensorflow for python from extracted filesystem
            tools = 'pip setuptools wheel'
            print(run_with_own_loader('$(pwd)/usr/local/bin/python -m pip install --upgrade %s' % tools), file=sys.stderr)

            # check the version of pip and python from extracted own filesystem
            document['payload']["own python"] = run_with_own_loader('$(pwd)/usr/local/bin/python --version')
            document['payload']["own pip"] = run_with_own_loader('$(pwd)/usr/local/bin/python -m pip --version')

            # check the version of pip and python from the default processing pipeline frame
            document['payload']["python"] = run('python3 --version')
            document['payload']["pip"] = run('python3 -m pip --version')

            # error message and trace should show up in the Insights Console
            if (document.get('metaData') or {}).get("hasError", None):
                # pass
                raise Exception('My Error')
                # also possible is exchange_data_holder.error = "Error"

        print("processed %s\n" % exchange_data_holder.id)

        return exchange_data_holder


if __name__ == "__main__":
    unpack_xz()
    fix_symbolic_links()
    input = sys.stdin.buffer
    output = sys.stdout.buffer
    sys.stdout = sys.stderr  # make any print in code going to stderr
    MyInsightsPythonStep(input, output).process_stream()
