#!/usr/bin/python3
from insights_protocol import StepBase, ExchangeDataHolder
from embedded_linux import create_env_variables, run, unpack_xz, fix_symbolic_links
import sys
import constant


class MyInsightsPythonStep(StepBase):

    # Called for every input
    async def invoke(self, exchange_data_holder: ExchangeDataHolder) -> ExchangeDataHolder:
        print("\nStart processing " + str(exchange_data_holder))

        for document in exchange_data_holder.documents:
            expression = str(document['payload']['expression'])
            document['payload']['result'] = run(create_env_variables() + ' ' +' $(pwd)/opt/ghc/9.4.5/lib/ghc-9.4.5/bin/ghc-9.4.5 -e "' + expression + '"', constant.OWN_FILE_SYSTEM_DIR)
            # error message and trace should show up in the Insights Console
            if (document.get('metaData') or {}).get('hasError', None):
                # pass
                raise Exception('My Error')
                # also possible is exchange_data_holder.error = "Error"

        print("processed %s\n" % exchange_data_holder.id)

        return exchange_data_holder


def patchelf(loader, executable):
    cmd_patchelf = '$(pwd)/usr/bin/patchelf --set-interpreter ' + loader + ' ' + executable
    print(run(cmd_patchelf, constant.OWN_FILE_SYSTEM_DIR), file=sys.stderr)


def patch_symlink_libc_libm():
    run('ln -svf $(pwd)/lib/x86_64-linux-gnu/libc-2.28.so $(pwd)/usr/lib/x86_64-linux-gnu/libc.so', constant.OWN_FILE_SYSTEM_DIR)
    run('ln -svf $(pwd)/lib/x86_64-linux-gnu/libm-2.28.so $(pwd)/usr/lib/x86_64-linux-gnu/libm.so', constant.OWN_FILE_SYSTEM_DIR)


if __name__ == "__main__":
    unpack_xz()
    fix_symbolic_links()
    patchelf(constant.OWN_ELF_LOADER, '$(pwd)/opt/ghc/9.4.5/lib/ghc-9.4.5/bin/ghc-9.4.5')
    patch_symlink_libc_libm()
    input = sys.stdin.buffer
    output = sys.stdout.buffer
    sys.stdout = sys.stderr  # make any print in code going to stderr
    MyInsightsPythonStep(input, output).process_stream()
