#!/usr/bin/python3
from insights_protocol import StepBase, ExchangeDataHolder
from embedded_linux import run_with_own_loader, run, unpack_xz, fix_symbolic_links
import sys
import constant

class MyInsightsPythonStep(StepBase):

    # Called for every input
    async def invoke(self, exchange_data_holder: ExchangeDataHolder) -> ExchangeDataHolder:
        print('\nStart processing ' + str(exchange_data_holder))

        for document in exchange_data_holder.documents:
            # Convert our payload map to a string (standard conversion).
            # Be aware that this will NOT create a JSON representation!
            payload = str(document['payload'])
            document['payload']['payload'] = payload

            document['payload']['uppercase'] = run_with_own_loader('$(pwd)/opt/build/main <<< "' + payload + '"')
            # This should not work - see pipeline application logs for details
            document['payload']['uppercase_without_loader'] = run('$(pwd)/opt/build/main <<< "' + payload + '"', constant.OWN_FILE_SYSTEM_DIR)

            # error message and trace should show up in the Insights Console
            if (document.get('metaData') or {}).get('hasError', None):
                # pass
                raise Exception('My Error')
                # also possible is exchange_data_holder.error = "Error"

        print("processed %s\n" % exchange_data_holder.id)

        return exchange_data_holder

if __name__ == '__main__':
    unpack_xz()
    fix_symbolic_links()
    input = sys.stdin.buffer
    output = sys.stdout.buffer
    sys.stdout = sys.stderr  # make any print in code going to stderr
    MyInsightsPythonStep(input, output).process_stream()
