import tensorflow as tf
import numpy as np
from os import makedirs, getcwd, path

mnist = tf.keras.datasets.mnist

scriptdir = getcwd()
targetdir = path.join( scriptdir, "export" )

(x_train, y_train), (x_test, y_test) = mnist.load_data()

images_database = np.concatenate( (x_train, x_test) )
result_database = np.concatenate( (y_train, y_test) )

def pre_generate_export_directories():
    for i in range(10):
        number_name = str(i)
        directory_name = path.join( targetdir, number_name )
        makedirs( directory_name, exist_ok=True )
        
def export_images():
    amount_of_images = len( images_database )
    for i in range( amount_of_images ):
        
        image = images_database[i]
        result = result_database[i]
        
        jpeg = tf.io.encode_jpeg( image.reshape(28,28,1) )
        
        number_name = str( result )
        image_file_name = f"{number_name}_{str(i)}_mnist.jpg"
        
        filepath = path.join( targetdir, number_name, image_file_name )
        
        tf.io.write_file( filepath, jpeg )
        
pre_generate_export_directories()
export_images()
